--
Sectors =
{
	--NORTH ROAD (LEVEL07)
	north_road =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,				--show on map
		post 			= true,				--can accept deliveries
		owner 			= PLAYER,				--owner
		stage 			= 1,					--evolution
		value 			= 1,					--strategic value
		income 			= 0,					--current income
		defense			= 0,					--defense rating in %
		reward			= 0,
		exclusive		= false,
		--Quest
		first_visit 	= true,
		guide_isAlive 	= true,
		picket_isAlive 	= true,
		carl_isAlive 	= true,
		carl_isRetired 	= false,
		isDone 			= false,
		isClean			= false,
		got_papers 		= 1,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = 4.900000,  y = 4.500000  },
		lt = { x = 5.300000,  y = 208.300003 },
		rt = { x = 211.500000, y = 208.300003 },
		rb = { x = 211.100006, y = 5.300000  },
	},
	--ROAD TO AIRPORT (RANDOM_02)
	road_to_airport =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= false,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 5,
		income 			= 0,
		defense			= 20,
		reward			= Awards.MEDIUM,
		exclusive		= false,
		--Quest
		is_first_capture = true,
		isDone 			= false,
		isClean			= false,
		blockpost 		= true,
		papers_worked	= false,

		lb = { x = 2.500000,  y = 2.900000  },
		lt = { x = 2.100001,  y = 71.900002 },
		rt = { x = 71.900002, y = 73.099998 },
		rb = { x = 72.500000, y = 2.500000  },
	},
	--AIRPORT (AIRPORT)
	airport =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= true,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 10,
		income 			= 5000,
		defense			= 40,
		reward			= Awards.LOT,
		exclusive		= false,
		--Quest
		first_visit 	= true,
		first_finish 	= true,
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = 14.900001,  y = 16.300001  },
		lt = { x = 15.500000,  y = 158.300003 },
		rt = { x = 158.100006, y = 157.900009 },
		rb = { x = 157.699997, y = 14.700000  },
	},
	--MOUNTAIN VILLAGE(BRIDGES)
	mountain_village =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= false,
		owner 			= BUTSI,
		stage 			= 1,
		value 			= 1,
		income 			= 0,
		defense			= 30,
		reward			= 0,
		exclusive		= true,
		--Quest
		isShammyAlive = true,
		isChieftainAlive = true,
		check_passed = false,
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = 4.900000,  y = 4.900000  },
		lt = { x = 5.299999,  y = 220.300003 },
		rt = { x = 279.100006, y = 218.500000 },
		rb = { x = 279.300018, y = 5.000000  },
	},
	--DAM (POWERPLANT)
	dam = 
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= false,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 5,
		income 			= 3500,
		defense			= 30,
		reward			= Awards.LOT,
		exclusive		= false,
		--Quest
		first_visit 	= true,
		leader_dead 	= false,
		isEscaped 		= false,
		first_finish 	= true,
		isDone 			= false,
		isClean			= false,
		blockpost 		= true,
		papers_worked	= false,

		lb = { x = 23.700001,  y = 22.900000  },
		lt = { x = 23.300001,  y = 288.100006 },
		rt = { x = 245.500000, y = 287.500000 },
		rb = { x = 244.100006, y = 23.300001  },
	},
	--OUTPOST	(SIGNAL_OFFICE_CENTER)
	outpost =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= false,
		post 			= false,
		owner 			= MARAUDERS,
		stage 			= 1,
		value 			= 1,
		income 			= 0,
		defense			= 20,
		reward			= Awards.SMALL,
		exclusive		= true,
		--Quest
		isGang1Killed = false,
		isGang2Killed = false,
		isJackalAlive = true,
		isRavenAlive = true,
		isShammyAlive = true,
		isJackalAngry = false,
		isRavenAngry = false,
		isDone		 	= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = -59.299999,  y = -73.300003  },
		lt = { x = -59.299995,  y = 42.499996 },
		rt = { x = 45.299999, y = 43.299999 },
		rb = { x = 45.500000, y = -73.300003  },
	},
	--NORTH BASE (MAINBRIDGE)
	north_base =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= false,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 5,
		income 			= 1500,
		defense			= 40,
		reward			= Awards.LOT,
		exclusive		= false,
		--Quest
		isDone 			= false,
		isClean			= false,
		blockpost 		= true,
		papers_worked	= false,

		lb = { x = -4.300000,  y = 3.900000  },
		lt = { x = -4.099997,  y = 197.500000 },
		rt = { x = 148.900009, y = 197.300003 },
		rb = { x = 149.900009, y = 3.500000  },
	},
	--PIRATE ISLAND (PIRATE_ISLAND)
	pirate_island =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= false,
		post 			= true,
		owner 			= PIRATS,
		stage 			= 1,
		value 			= 0,
		income 			= 3000,
		defense			= 30,
		reward			= 0,
		exclusive		= true,
		--Quest
		entryPoint = 0,	--1-CORP, 2-BUTSI, 3-MARA, 4-ARMY, -1-finished
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,
	},
	--ROAD BLOCK (RANDOM_03)
	roadblock =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= false,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 5,
		income 			= 3000,
		defense			= 15,
		reward			= Awards.ADEQUATE,
		exclusive		= false,
		--Quest
		is_first_capture = true,
		isClean			= false,
		isDone 			= false,
		blockpost 		= true,
		papers_worked	= false,
		lb = { x = 10.100000,  y = 10.499994  },
		lt = { x = 10.300000,  y = 105.099998 },
		rt = { x = 104.300003, y = 104.700005 },
		rb = { x = 104.500000, y = 10.900001  },
	},
	--MINES (MORTAR)
	mines =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= false,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 5,
		income 			= 20000,
		defense			= 20,
		reward			= Awards.ADEQUATE,
		exclusive		= false,
		--Quest
		first_visit 	= true,
		first_finish 	= true,
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = 76.500000,  y = -125.300003  },
		lt = { x = 75.700005,  y = 127.500000 },
		rt = { x = 337.100006, y = 127.099998 },
		rb = { x = 335.899994, y = -126.300003  },
	},
	--SAFARI (LEVEL06)
	safari	=
	{	--Service
		status 				= NOT_AVAILABLE,
		enabled 			= true,
		post 				= false,
		owner 				= MARAUDERS,
		stage 				= 1,
		value 				= 0,
		income 				= 0,
		defense				= 0,
		reward				= 0,
		exclusive			= false,
		--Quest
		isMaraGotHelp = false,
		first_visit 		= true,
		runaway_dead 		= false,
		leader_dead 		= false,
		is_runaway_spawned 	= false,
		isDone 				= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = -92.500000,  y = -87.900002  },
		lt = { x = -93.300003,  y = 94.900002 },
		rt = { x = 90.300003, y = 94.900002 },
		rb = { x = 90.099991, y = -87.700005  },
	},
	--TRAIN STATION (RAILROAD_STATION)
	trainstation =
	{ 	--Service
		status 					= NOT_AVAILABLE,
		enabled 				= true,
		post 					= true,
		owner 					= ARMY,
		stage 					= 1,
		value 					= 5,
		income 					= 1500,
		defense					= 20,
		reward					= Awards.LOT,
		exclusive		= false,
		--Quest
		first_visit 			= true,
		isDone 					= false,
		mechanic_isAlive 		= true,
		station_boss_isAlive 	= true,
		louis_isAlive 			= true,
		first_finish 			= true,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,
		lb = { x = 3.900000,  y = 4.300000  },
		lt = { x = 4.300000,  y = 147.500000 },
		rt = { x = 147.900009, y = 147.100006 },
		rb = { x = 148.100006, y = 4.500000  },
	},
	--COASTAL CITY (BANK)
	coastal_city =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= true,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 3,
		income 			= 0,
		defense			= 35,
		reward			= Awards.LOT,
		exclusive		= false,
		--Quest
		militia_isAlive = true,
		governor_isAlive = true,
		mafia_isAlive = true,
		guards_isAlive = true,
		captain_fero_isAlive = true,
		militia_isAlive = true,
		mafia_isEnemy = false,
		militia_isEnemy = false,
		guards_isEnemy = false,
		supported_side = 0, --0->init value 1-noone, 2-militia, 3-mafia, 4-guards
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = 6.700000,  y = 6.700000  },
		lt = { x = 8.900001,  y = 354.700012 },
		rt = { x = 200.100006, y = 354.300018 },
		rb = { x = 201.900009, y = 6.800000  },

	},
	--COASTAL FORTRESS (COASTAL_FORTRESS)
	coastal_fortress =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 		= true,
		owner 		= ARMY,
		stage 		= 1,
		value 		= 5,
		income 		= 0,
		defense		= 30,
		reward			= Awards.BIG,
		exclusive		= false,
		--Quest
		is_first_capture = true,
		isDone 		= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = -119.700005,  y = -119.700005  },
		lt = { x = -118.299988,  y = 119.099998 },
		rt = { x = 117.700005, y = 118.099998 },
		rb = { x = 119.099998, y = -119.700005  },
	},
	--PORT (HARBOR)
	port =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= true,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 10,
		income 			= 2500,
		defense			= 25,
		reward			= Awards.BIG,
		exclusive		= false,
		--Quest
		first_finish 	= true,
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,
		lb = { x = 5.900000,  y = 4.300000  },
		lt = { x = 7.299999,  y = 272.100006 },
		rt = { x = 176.100006, y = 273.300018 },
		rb = { x = 176.100006, y = 4.500000  },
	},
	--PALACE (PRESIDENTSPALACE)
	palace =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= true,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 10,
		income 			= 1000,
		defense			= 75,
		reward			= Awards.MAX,
		exclusive		= false,
		--Quest
		boss1_is_spawned = false,
		boss2_is_spawned = false,
		boss_is_Alive 	= true,
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = 24.900000,  y = 25.500000  },
		lt = { x = 26.500000,  y = 287.300018 },
		rt = { x = 261.100006, y = 287.100006 },
		rb = { x = 260.300018, y = 23.700001  },
	},
	--CROSSROADS (LEVEL08)
	crossroads =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= false,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 5,
		income 			= 0,
		defense			= 30,
		reward			= Awards.NOTMUCH,
		exclusive		= false,
		--Quest
		is_first_capture = true,
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,
		 
		lb = { x = -113.700005,  y = -115.099998  },
		lt = { x = -112.900002,  y = 113.300003 },
		rt = { x = 110.500000, y = 113.300003 },
		rb = { x = 110.700005, y = -115.700005  },
	},
	--DRUG DEAL (SHIPS)
	drug_deal =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= false,
		post 			= false,
		owner 			= PIRATS,
		stage 			= 1,
		value 			= 0,
		income 			= 0,
		defense			= 0,
		reward			= 0,
		exclusive		= true,
		--Quest
		entryPoint = 0, --1-CORP, 2-BUTSI, 3-MARA, 4-ARMY, -1-finished
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,
	},
	--SOUTHERN VILLAGE (VILLAGE)
	south_village =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= false,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 10,
		income 			= 0,
		defense			= 20,
		reward			= 0,
		exclusive		= false,
		--Quest
		is1stHelp = true,
		is1stVisit = true,
		willHelpButsi 			= false,
		willHelpMara 			= false,
		willHelpArmy 			= false,
		isButsiKilled = false,
		isMaraKilled = false,
		isArmyKilled = false,		
		isCivKilled = false,
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = 15.500000,  y = 14.300000  },
		lt = { x = 16.100000,  y = 178.100006 },
		rt = { x = 178.699997, y = 177.300003 },
		rb = { x = 178.500000, y = 14.900001  },
	},
	--MILITARY BASE (MILITARY_BASE)
	base =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= true,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 10,
		income 			= 0,
		defense			= 50,
		reward			= Awards.MAX,
		exclusive		= false,
		--Quest
		isShammyReadyForSave = false,
		isApprenticeAlive = true,
		first_finish 	= true,
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,
	 
		lb = { x = 10.500000,  y = 8.900001  },
		lt = { x = 11.300000,  y = 296.300018 },
		rt = { x = 297.300018, y = 294.100006 },
		rb = { x = 295.100006, y = 7.700000  },
	},
	--UN CAMP (OON)
	un_camp =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= true,
		owner 			= UN,
		stage 			= 1,
		value 			= 0,
		income 			= 1000,
		defense			= 50,
		reward			= 0,
		exclusive		= false,
		--Quest
		isUNCampAttackedBy = 0, --0->initial value 1-> MARA 2->ARMY 3->was attacked already
		siege_decision = 0, --0->initial value 1->agree (UN)  2->decline (neutral) 3->agree (help to attacker)
		isUNLeaderAlive = true,
		isShammyAlive = true,
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = 20.100000,  y = 32.500000  },
		lt = { x = 19.500000,  y = 251.300003 },
		rt = { x = 238.100006, y = 251.699997 },
		rb = { x = 238.699997, y = 32.500000  },
	},
	--SEVEN STREAMS (RANDOM_01)
	stream =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= false,
		owner 			= ARMY,
		stage 			= 1,
		value 			= 1,
		income 			= 0,
		defense			= 10,
		reward			= Awards.SMALL,
		exclusive		= false,
		--Quest
		isMaraRemarkTold = false,
		isButsiSpawned = false,
		isButsiKilled = false,
		isMaraKilled = false,
		isArmyKilled = false,
		isMaraAttacked = false,
		isArmyAttacked = false,
		isButsiAttacked = false,
		is1stVisit = true,
		isDone 			= false,
		isClean			= false,
		blockpost 		= true,
		papers_worked	= false,

		lb = { x = 14.300002,  y = 13.099998  },
		lt = { x = 14.100000,  y = 108.700005 },
		rt = { x = 109.099998, y = 108.300003 },
		rb = { x = 109.500000, y = 12.700002  },
	},
	--DETOUR ROAD (LEVEL03)
	detour_road =
	{ 	--Service
		status 			= NOT_AVAILABLE,
		enabled 		= true,
		post 			= false,
		owner 			= ARMY,		--MARAUDERS
		stage 			= 1,
		value 			= 2,
		income 			= 1500,
		defense			= 15,
		reward			= 0,
		exclusive		= false,
		--Quest
		is_first_capture = true,
		isShammyAlive = true,
		isDone 			= false,
		isClean			= false,
		blockpost 		= false,
		papers_worked	= false,

		lb = { x = 16.500000,  y = 14.700009  },
		lt = { x = 16.100000,  y = 277.100006 },
		rt = { x = 301.100006, y = 275.700012 },
		rb = { x = 300.500000, y = 15.700003  },
	}
	--
}
--
Positions = 
{
	airport 			= "6.90093, 8.71959",
	base 				= "6.66823, 10.5881",
	coastal_city 		= "10.1384, 8.96102",
	coastal_fortress 	= "9.58119, 10.5367",
	crossroads 			= "8.12873, 10.2914",
	dam 				= "11.0603, 7.58041",
	detour_road			= "5.57249, 8.35527",
	drug_deal 			= "11.6384, 11.3903",
	mines 				= "5.31896, 6.76856",
	mountain_village 	= "12.2558, 6.90787",
	north_base 			= "11.8414, 5.35896",
	north_road 			= "7.71085, 5.12810",
	outpost 			= "3.95952, 5.71027",
	palace 				= "6.69345, 12.1335",
	pirate_island 		= "12.5848, 9.01174",
	port 				= "8.72633, 11.5955",
	road_to_airport 	= "8.51351, 8.66082",
	roadblock 			= "9.93846, 6.76025",
	safari 				= "10.3659, 5.12275",
	south_village 		= "5.03869, 12.2821",
	stream				= "5.29306, 9.60013",
	trainstation 		= "7.86785, 6.73846",
	un_camp 			= "5.33800, 10.8704"
}
--
Joints =		-- distance in "game minutes", entrance = spawn area name
{
	--
	north_road =
	{
		trainstation =	
		{
			entrance 	= "north",
			blockpost	= false,			
			distance 	= 240,	
			path_old	= "591,88,626,108,649,116,671,124,648,129,623,130,601,138,581,149,534,151",
			path		= "7.21266, 5.15081, 6.88026, 5.19509, 6.56473, 5.13056, 6.56473, 5.39383, 6.88404, 5.56319, 7.15858, 5.80855, 7.21567, 6.16883, 7.4676, 6.40348"
		},
		--
		roadblock =	
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 240,
			path_old 	= "591,88,550,101,529,103,508,111,486,117,464,123,438,127,394,130",
			path		= "8.08976, 5.43511, 8.44535, 5.79804, 8.76045, 6.19717, 9.03083, 6.58729, 9.40537, 6.7599"
		}
	},
	--
	road_to_airport =
	{
		trainstation =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 210,
			path_old	= "392,224,434,205,459,197,483,189,502,173,534,151",
			path		= "8.30639, 8.17527, 8.01573, 7.76193, 7.92735, 7.30755"
		},
		--
		dam	=
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 180,
			path_old 	= "392,224,346,193,329,169,315,144,296,117",
			path		= "9.04509, 8.7443, 9.48152, 8.45285, 9.86165, 8.16104, 10.2097, 7.85265, 10.6067, 7.72218"
		},
		--
		airport	=
		{
			entrance 	= "west",
			blockpost	= true,
			distance 	= 90,
			path_old	= "392,224,451,244,470,248,523,251",
			path		= "7.93545, 8.9102, 7.35201, 8.81219"
		},
		--
		crossroads =
		{
			entrance 	= "north",
			blockpost	= true,
			distance 	= 120,
			path_old	= "392,224,377,263,405,279,390,287,370,319",
			path		= "8.61593, 9.22799, 8.43714, 9.56046, 8.02379, 9.69016"
		}
	},
	--
	airport =
	{
		road_to_airport	=
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 90,
			path_old	= "523,251,470,248,451,244,392,224",
			path		= "7.35201, 8.81219, 7.93545, 8.9102"
		}
	},
	--
	mountain_village =
	{
		dam	=
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "210,68,214,99,234,107,250,113,296,117",
			path		= "12.0064, 7.48714, 11.5566, 7.61327"
		},
		--
		north_base =
		{ 
			entrance 	= "south",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "210,68,256,73,254,53,288,27",
			path		= "12.2228, 6.32982, 12.076, 5.98561"
		},
		--
--		drug_deal =
--		{ 
--			entrance 	= "north",
--			blockpost	= false,
--			distance 	= 120,
--			path_old 	= "",
--			path		= "12.4832, 7.28065, 12.4182, 7.74502, 12.0863, 8.11979, 11.9165, 8.56694, 11.8277, 9.05401, 11.6744, 9.54048, 11.6911, 10.0183, 11.9264, 10.4145, 11.87, 10.8588"
--		},
		--
		pirate_island =
		{ 
			entrance 	= "north",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "",
			path		= "12.531, 7.28309, 12.8057, 7.6388, 12.9195, 8.06845, 12.8623, 8.50915"
		}
	},
	--
	dam = 
	{
		mountain_village =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "296,117,250,113,234,107,214,99,210,68",
			path		= "11.5566, 7.61327, 12.0064, 7.48714"
		},
		--
		roadblock =
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 75,
			path_old 	= "296,117,346,130,394,130",
			path		= "10.5743, 7.57485, 10.1534, 7.26733"
		},
		--
		road_to_airport	=
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 180,
			path_old 	= "296,117,315,144,329,169,346,193,392,224",
			path		= "10.6067, 7.72218, 10.2097, 7.85265, 9.86165, 8.16104, 9.48152, 8.45285, 9.04509, 8.7443"
		},
		--
		coastal_city =
		{
			entrance 	= "north",
			blockpost	= true,
			distance 	= 120,
			path_old 	= "296,117,278,147,267,187",
			path		= "10.7205, 8.06942, 10.2511, 8.2715"
		}
	},
	--
	outpost =
	{
		mines =
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "741,135,741,163,730,174,698,200",
			path		= "4.31735, 6.07724, 4.65187, 6.23365, 4.98607, 6.39796"
		},
		trainstation =
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 220,
			path_old 	= "",
			path		= "4.51525, 5.49448, 5.12585, 5.4413, 5.4847, 5.86895, 5.89529, 6.14253, 6.24324, 6.5248, 6.84937, 6.53052, 7.42156, 6.53559"
		}
	},
	--
	north_base =
	{
		mountain_village =
		{
			entrance 	= "north",
			blockpost	= true,
			distance 	= 120,
			path_old 	= "288,27,254,53,256,73,210,68",
			path		= "12.076, 5.98561, 12.2228, 6.32982"
		},
		--
		safari =
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "288,27,326,36,349,40,385,61",
			path		= "11.6547, 4.70822, 11.1654, 4.69544, 10.8223, 5.02465"
		},
		--
		roadblock =
		{
			entrance 	= "north",
			blockpost	= false,
			distance 	= 140,
			path_old 	= "",
			path		= "11.3932, 5.27508, 11.0292, 5.64063, 10.6898, 5.97336, 10.375, 6.37043"
		}
	},
	--
	pirate_island =
	{
		coastal_city =
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 240,
			path_old 	= "106,128,267,187",
			path		= "12.1045, 9.00683, 11.6351, 8.89351, 11.1491, 8.90887, 10.6616, 9.00452"
		},
		--
		port =
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 300,
			path_old 	= "106,128,253,373",
			path		= "12.3694, 9.52381, 11.8833, 9.63845, 11.3976, 9.79341, 10.9042, 10.0453, 10.7188, 10.5074, 10.6065, 11.0336, 10.1867, 11.3487, 9.68637, 11.3882, 9.18647, 11.5572"
		},
		--
		drug_deal =
		{
			entrance 	= "north",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "106,128,60,221",
			path		= "12.4144, 9.53495, 12.4143, 9.91639, 12.3698, 10.3213, 12.2283, 10.6732, 12.0138, 10.9727"
		},
		--
		mountain_village =
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 150,
			path_old 	= "106,128,210,68",
			path		= "12.8623, 8.50915, 12.9195, 8.06845, 12.8057, 7.6388, 12.531, 7.28309"
		}
	},
	--
	roadblock =
	{
		north_road =
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 240,
			path_old 	= "394,130,438,127,464,123,486,117,508,111,529,103,550,101,591,88",
			path		= "9.40537, 6.7599, 9.03083, 6.58729, 8.76045, 6.19717, 8.44535, 5.79804, 8.08976, 5.43511"
		},
		--
		safari =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "394,130,372,103,372,86,385,61",
			path		= "10.3679, 6.36897, 10.5208, 6.05301, 10.5594, 5.67972"
		},
		--
		trainstation =
		{
			entrance 	= "west",
			blockpost	= true,
			distance 	= 150,
			path_old 	= "394,130,438,135,464,133,492,135,534,151",
			path		= "9.41072, 6.76488, 9.07088, 6.83754, 8.74695, 6.68337, 8.3822, 6.53712"
		},
		--
		dam	=
		{ 
			entrance 	= "east",
			blockpost	= true, 
			distance 	= 75,	
			path_old 	= "394,130,346,130,296,117",
			path		= "10.1534, 7.26733, 10.5743, 7.57485"
		},
		--
		north_base =
		{
			entrance 	= "south",
			blockpost	= true,
			distance 	= 120,
			path_old 	= "",
			path		= "10.375, 6.37043, 10.6898, 5.97336, 11.0292, 5.64063, 11.3932, 5.27508"
		}
	},
	--
	mines =
	{
		outpost	=
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "698,200,730,174,741,163,741,135",
			path		= "4.98607, 6.39796, 4.65187, 6.23365, 4.31735, 6.07724"
		},
		--
		detour_road =
		{
			entrance 	= "north",
			blockpost	= false,
			distance 	= 150,
			path_old 	= "698,200,660,234,657,257,638,289",
			path		= "5.69301, 7.03349, 5.76691, 7.40031, 5.67885, 7.78286"
		}
	},
	--
	safari	=
	{
		roadblock =
		{
			entrance 	= "north",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "385,61,372,86,372,103,394,130",
			path		= "10.5594, 5.67972, 10.5208, 6.05301, 10.3679, 6.36897"
		},
		--
		north_base =
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 120,
			path_old	= "385,61,349,40,326,36,288,27",
			path		= "10.8223, 5.02465, 11.1654, 4.69544, 11.6547, 4.70822"
		}
	},
	--
	trainstation =
	{
		--
		roadblock =
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 150,
			path_old 	= "534,151,492,135,464,133,438,135,394,130",
			path		= "8.3822, 6.53712, 8.74695, 6.68337, 9.07088, 6.83754, 9.41072, 6.76488"
		},
		--
		road_to_airport	=
		{
			entrance 	= "north",
			blockpost	= false,
			distance 	= 210,
			path_old 	= "534,151,502,173,483,189,459,197,434,205,392,224",
			path		= "7.92735, 7.30755, 8.01573, 7.76193, 8.30639, 8.17527"
		},
		--
		detour_road	=
		{
			entrance 	= "north",
			blockpost	= false,
			distance 	= 300,
			path_old 	= "534,151,502,173,511,193,534,201,558,205,582,206,607,208,631,212,632,233,630,255,638,289",
			path		= "7.91987, 7.30724, 7.56369, 7.57513, 7.08643, 7.52701, 6.69864, 7.35755, 6.30311, 7.1802, 6.06173, 7.48871, 5.95008, 7.8616"
		},
		--
		north_road =
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 240,
			path_old 	= "534,151,581,149,601,138,623,130,648,129,671,124,649,116,626,108,591,88",
			path		= "7.4676, 6.40348, 7.21567, 6.16883, 7.15858, 5.80855, 6.88404, 5.56319, 6.56473, 5.39383, 6.56473, 5.13056, 6.88026, 5.19509, 7.21266, 5.15081"
		},
		--
		outpost =
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 240,
			path		= "7.42156, 6.53559, 6.84937, 6.53052, 6.24324, 6.5248, 5.89529, 6.14253, 5.4847, 5.86895, 5.12585, 5.4413, 4.51525, 5.49448"
		}
	},
	--
	coastal_city =
	{
		pirate_island =
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 240,
			path_old 	= "267,187,106,128",
			path		= "10.6616, 9.00452, 11.1491, 8.90887, 11.6351, 8.89351, 12.1045, 9.00683"
		},
		--
		dam	=
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "267,187,278,147,296,117",
			path		= "10.2511, 8.2715, 10.7205, 8.06942"
		},
		--
		coastal_fortress =
		{
			entrance 	= "north",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "267,187,297,222,290,244,256,270",
			path		= "9.71057, 9.13577, 9.67594, 9.43995, 9.5326, 9.69797, 9.42373, 9.97284"
		},
		--
		crossroads =
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 210,
			path_old 	= "267,187,297,222,290,244,321,264,352,283,370,319",
			path		= "9.71057, 9.13577, 9.68167, 9.43423, 9.52687, 9.69797, 9.21196, 9.73246, 8.92596, 9.88709, 8.56581, 9.99575"
		}
		--
--		drug_deal =
--		{
--			entrance 	= "east",
--			blockpost	= false,
--			distance 	= 180,
--			path_old 	= "267,187,60,221",
--			path		= "10.471, 9.4114, 10.8201, 9.72806, 11.1042, 10.1496, 11.2504, 10.6272, 11.2913, 11.0961"
--		}
	},
	--
	coastal_fortress =
	{
		coastal_city =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 120,
			path_old	= "256,270,290,244,297,222,267,187",
			path		= "9.42373, 9.97284, 9.5326, 9.69797, 9.67594, 9.43995, 9.71057, 9.13577" 
		},
		--
		crossroads =
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 180,
			path_old 	= "256,270,297,222,290,244,321,264,352,283,370,319",
			path		= "9.42337, 9.976, 9.5327, 9.69447, 9.21247, 9.7335, 8.92632, 9.88146, 8.56543, 9.99522"
		},
		--
		port =
		{
			entrance 	= "north",
			blockpost	= true,
			distance 	= 150,
			path_old 	= "256,270,284,298,288,315,282,333,288,351,253,373",
			path		= "9.05704, 10.5918, 8.89703, 10.8146, 8.75406, 11.0205"
		}
	},
	--
	port =
	{
		pirate_island =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 300,
			path_old 	= "253,373,106,128",
			path		= "9.18647, 11.5572, 9.68637, 11.3882, 10.1867, 11.3487, 10.6065, 11.0336, 10.7188, 10.5074, 10.9042, 10.0453, 11.3976, 9.79341, 11.8833, 9.63845, 12.3694, 9.52381"
		},
		--
		palace =
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 180,
			path_old 	= "253,373,295,393,302,423,314,451,340,465,402,453",
			path		= "8.26772, 11.6764, 8.07942, 11.9683, 7.88523, 12.1975, 7.66794, 12.4557, 7.34734, 12.5881, 7.08374, 12.3596"
		},
		--
		crossroads =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "253,373,306,359,315,346,332,341,370,319",
			path		= "8.27001, 11.1056, 8.1551, 10.8476"
		},
		--
--		drug_deal =
--		{
--			entrance 	= "east",
--			blockpost	= false,
--			distance 	= 260,
--			path_old 	= "253,373,60,221",
--			path		= "9.18444, 11.5823, 9.67801, 11.7756, 10.1629, 11.8558, 10.607, 11.75, 10.9551, 11.5476"
--		},
		--
		coastal_fortress =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 150,
			path_old 	= "253,373,288,351,282,333,288,315,284,298,256,270",
			path		= "8.75406, 11.0205, 8.89703, 10.8146, 9.05704, 10.5918"
		}
	},
	--
	palace =
	{
		south_village =
		{
			entrance 	= "west",
			blockpost	= false,
			distance 	= 150,
			path_old 	= "402,453,463,480,500,500,527,533",
			path		= "6.1891, 12.1639, 5.87261, 12.1185, 5.56156, 12.1705"
		},
		--
		base =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 150,
			path_old 	= "402,453,434,413,457,401,478,392,516,370",
			path		= "6.75738, 11.5654, 6.64261, 11.1407"
		},
		--
		port =
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 180,
			path_old 	= "402,453,340,465,314,451,302,423,295,393,253,373",
			path		= "7.08374, 12.3596, 7.34734, 12.5881, 7.66794, 12.4557, 7.88523, 12.1975, 8.07942, 11.9683, 8.26772, 11.6764"
		}
	},
	--
	crossroads =
	{
		coastal_fortress =
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 180,
			path_old 	= "370,319,352,283,321,264,290,244,297,222,256,270",
			path		= "8.56543, 9.99522, 8.92632, 9.88146, 9.21247, 9.7335, 9.5327, 9.69447, 9.42337, 9.976"
		},
		--
		coastal_city =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 210,
			path_old 	= "370,319,352,283,321,264,290,244,297,222,267,187",
			path		= "8.56581, 9.99575, 8.92596, 9.88709, 9.21196, 9.73246, 9.52687, 9.69797, 9.68167, 9.43423, 9.71057, 9.13577"
		},
		--
		port =
		{
			entrance 	= "north",
			blockpost	= true,
			distance 	= 120,
			path_old	= "370,319,332,341,315,346,306,359,253,373",
			path		= "8.1551, 10.8476, 8.27001, 11.1056"
		},
		--
		base =
		{
			entrance 	= "west",
			blockpost	= true,
			distance 	= 150,
			path_old 	= "370,319,410,346,434,356,455,366,516,370",
			path		= "7.70075, 10.7669, 7.44942, 10.6451, 7.13357, 10.645"
		},
		--
		road_to_airport	=
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 150,
			path_old 	= "370,319,390,287,405,279,377,263,392,224",
			path		= "8.02379, 9.69016, 8.43714, 9.56046, 8.61593, 9.22799"
		}
	},
	--
	drug_deal =
	{
		pirate_island =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "60,221,106,128",
			path		= "12.0138, 10.9727, 12.2283, 10.6732, 12.3698, 10.3213, 12.4143, 9.91639, 12.4144, 9.53495"
		}
		--
--		port =
--		{
--			entrance 	= "west",
--			blockpost	= false,
--			distance 	= 260,
--			path_old 	= "60,221,253,373",
--			path		= "10.9551, 11.5476, 10.607, 11.75, 10.1629, 11.8558, 9.67801, 11.7756, 9.18444, 11.5823"
--		},
		--
--		coastal_city =
--		{
--			entrance 	= "west",
--			blockpost	= false,
--			distance 	= 180,
--			path_old 	= "60,221,267,187",
--			path		= "11.2913, 11.0961, 11.2504, 10.6272, 11.1042, 10.1496, 10.8201, 9.72806, 10.471, 9.4114"
--		},
		--
--		mountain_village =
--		{
--			entrance 	= "south",
--			blockpost	= false,
--			distance 	= 180,
--			path_old 	= "",
--			path		= "11.87, 10.8588, 11.9264, 10.4145, 11.6911, 10.0183, 11.6744, 9.54048, 11.8277, 9.05401, 11.9165, 8.56694, 12.0863, 8.11979, 12.4182, 7.74502, 12.4832, 7.28065"
--		}
	},
	--
	south_village =
	{
		palace =
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 150,
			path_old 	= "527,533,500,500,463,480,402,453",
			path		= "5.56156, 12.1705, 5.87261, 12.1185, 6.1891, 12.1639"
		},
		--
		un_camp	=
		{
			entrance	= "south",
			blockpost	= false,
			distance 	= 90,
			path_old 	= "527,533,577,510,581,495,573,448",
			path		= "4.9044, 11.6493, 5.13021, 11.5347, 5.34812, 11.4361"
		}
	},
	--
	base =
	{
		palace =
		{
			entrance 	= "north",
			blockpost	= true,
			distance 	= 150,
			path_old 	= "516,370,478,392,457,401,434,413,402,453",
			path		= "6.64261, 11.1407, 6.75738, 11.5654"
		},
		--
		crossroads =
		{
			entrance 	= "east",
			blockpost	= true,
			distance 	= 150,
			path_old 	= "516,370,455,366,434,356,410,346,370,319",
			path		= "7.13357, 10.645, 7.44942, 10.6451, 7.70075, 10.7669"
		},
		--
		stream =
		{
			entrance 	= "west",
			blockpost	= true,
			distance 	= 120,
			path_old 	= "516,370,561,358,587,358,642,371",
			path		= "6.28932, 10.0459, 5.98554, 9.9768, 5.73414, 9.85089"
		}
	},
	--
	un_camp =
	{
		south_village =
		{
			entrance 	= "north",
			blockpost	= false,
			distance 	= 90,
			path_old 	= "573,448,581,495,577,510,527,533",
			path		= "5.34812, 11.4361, 5.13021, 11.5347, 4.9044, 11.6493"
		},
		--
		stream =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "573,448,582,415,595,400,642,371",
			path		= "5.31124, 10.3233, 5.27882, 10.1442"
		}
	},
	--
	stream =
	{
		base =
		{
			entrance 	= "east",
			blockpost	= false,
			distance 	= 120,
			path_old 	= "642,371,587,358,561,358,516,370",
			path		= "5.73414, 9.85089, 5.98554, 9.9768, 6.28932, 10.0459"
		},
		--
		un_camp	=
		{
			entrance 	= "north",
			blockpost	= false,
			distance 	= 120,
			path_old	= "642,371,595,400,582,415,573,448",
			path		= "5.27882, 10.1442, 5.31124, 10.3233"
		},
		--
		detour_road	=
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 105,
			path_old 	= "642,371,630,338,640,327,638,289",
			path		= "5.34621, 9.05264, 5.35, 8.86195"
		}
	},
	--
	detour_road =
	{
		trainstation =
		{
			entrance 	= "south",
			blockpost	= false,
			distance 	= 300,
			path_old 	= "638,289,630,255,632,233,631,212,607,208,582,206,558,205,534,201,511,193,502,173,534,151",
			path		= "5.95008, 7.8616, 6.06173, 7.48871, 6.30311, 7.1802, 6.69864, 7.35755, 7.08643, 7.52701, 7.56369, 7.57513, 7.91987, 7.30724"
		},
		--
		mines =
		{
			entrance 	= "south",
			blockpost	= true,
			distance 	= 150,
			path_old 	= "638,289,657,257,660,234,698,200",
			path		= "5.67885, 7.78286, 5.76691, 7.40031, 5.69301, 7.03349"
		},
		--
		stream =
		{
			entrance 	= "north",
			blockpost	= true,
			distance 	= 105,
			path_old 	= "638,289,640,327,630,338,642,371",
			path		= "5.35, 8.86195, 5.34621, 9.05264"
		}
	}
	--
}
--
if (DEBUG == true) then
		Sectors["test_level"] = { status = NOT_STARTED, enabled = true, owner = PLAYER, stage = 1, value = 0, post = true, income = 0 }
		Joints["test_level"] = {}
end
